//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#define WIN32_LEAN_AND_MEAN

#include <Windows.H>
#include <WindowsX.H>
#include <SQL.H>
#include <SqlExt.H>
#include <ShellAPI.H>
#include <ShlOBJ.H>
#include <Stdio.H>
#include <Stdlib.H>

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "SQLRoutines.H"

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void DBCloseCursor(HSTMT StatementHandle)
{
    if(StatementHandle != NULL)
    {
        SQLFreeHandle(SQL_HANDLE_STMT, StatementHandle);
        StatementHandle = NULL;
    }
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool DBFetch(HSTMT StatementHandle)
{
    if(StatementHandle == NULL)
        return false;

    SQLRETURN Result = 0;

    Result = SQLFetch(StatementHandle);
    if(SQL_SUCCEEDED(Result))
        return true;

    return false;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool DBGetData(HSTMT StatementHandle, SQLUSMALLINT ColumnNumber, SQLSMALLINT TargetType, SQLPOINTER TargetValuePtr, SQLINTEGER BufferLength, SQLINTEGER *StrLen_or_IndPtr)
{
    if(StatementHandle == NULL)
        return false;

    SQLRETURN Result = SQLGetData(StatementHandle, ColumnNumber, TargetType, TargetValuePtr, BufferLength, StrLen_or_IndPtr);

    if(SQL_SUCCEEDED(Result) && StrLen_or_IndPtr > 0)
        return true;

    return false;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

